<?php
/**
 * WebEngine Lottery Plugin
 * https://webenginecms.org/
 * 
 * @version 2.0.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2017 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

if(!isLoggedIn()) redirect(1,'login');

echo '<div class="lottery-container">';
	echo '<div class="lottery-container-menu">';
		echo '<ul>';
			echo '<li><a href="'.__LOTTERY_HOME__.'">'.lang('lottery_menu_1', true).'</a></li>';
			if(isLoggedIn()) echo '<li><a href="'.__LOTTERY_HOME__.'history/">'.lang('lottery_menu_2', true).'</a></li>';
				if(isLoggedIn()) echo '<li><a href="'.__LOTTERY_HOME__.'stash/">'.lang('lottery_menu_3', true).'</a></li>';
			echo '<li><a href="'.__LOTTERY_HOME__.'results/">'.lang('lottery_menu_4', true).'</a></li>';
			echo '<li><a href="'.config('website_forum_link', true).'" target="_blank">'.lang('lottery_menu_5', true).'</a></li>';
		echo '</ul>';
	echo '</div>';
	echo '<div class="lottery-container-head"></div>';
	echo '<div class="lottery-container-content">';
		try {
			// Check if user is online
			if(!isLoggedIn()) throw new Exception(lang('lottery_error_10',true));

			// Lottery Instance
			$Lottery = new \Plugin\Lottery\Lottery();
			$Lottery->setUserid($_SESSION['userid']);

			// Check current stage
			if(!$Lottery->canBuyTicket()) redirect(1, 'lottery');
			
			// PURCHASE SUBMIT
			if(check_value($_POST['buyticket_submit'], $_POST['buyticket_numbers'])) {
				$ticketNumbers = explode(",", $_POST['buyticket_numbers']);
				if(!is_array($ticketNumbers)) throw new Exception(lang('lottery_error_11',true));
				if(count($ticketNumbers) != 4) throw new Exception(lang('lottery_error_11',true));

				$Lottery->setLuckyNumber($ticketNumbers[0]);
				$Lottery->setLuckyNumber($ticketNumbers[1]);
				$Lottery->setLuckyNumber($ticketNumbers[2]);
				$Lottery->setLuckyNumber($ticketNumbers[3]);
				$Lottery->buyTicket();
				
				message('success', lang('lottery_success_1',true));
			}
			
			echo '<div style="margin-bottom: 100px;">';
				echo '<form action="" method="post">';
					echo '<input type="hidden" id="buyticket_numbers" name="buyticket_numbers"/>';
					echo '<div class="lottery-ticket">';
						echo '<span class="title">'.lang('lottery_txt_19', true).'</span>';
						echo '<p>'.lang('lottery_txt_20', true).'</p>';
						echo '<ul id="ticketnumbers">';
							for($i=$Lottery->getMinNumber(); $i<=$Lottery->getMaxNumber(); $i++) {
								echo '<li id="'.$i.'">'.$i.'</li>';
							}
						echo '</ul>';
						echo '<button class="lottery-buyticket-submit" type="submit" name="buyticket_submit" value="ok">'.lang('lottery_txt_4', true).'</button>';
					echo '</div>';
				echo '</form>';
			echo '</div>';


		} catch (Exception $ex) {
			message('error', $ex->getMessage());
		}
	echo '</div>';
echo '</div>';
?>
<script>
window.onload = function() {
	var ul = document.getElementById('ticketnumbers');
	var sNumbers = [];

	ul.addEventListener('click', function(e) {
		if (e.target.tagName === 'LI') {
			if(document.getElementById(e.target.id).className == "lottery-selected-number") {
				document.getElementById(e.target.id).className = "";
				sNumbers.splice(sNumbers.indexOf(e.target.id), 1);
			} else {
				if(sNumbers.length < 4) {
					document.getElementById(e.target.id).className = "lottery-selected-number";
					sNumbers.push(e.target.id);
				}
			}
			document.getElementById("buyticket_numbers").value = sNumbers;
		}
	});
}
</script>